/* - MCCurrentUpdateListener -
 * Display the data from a current update event
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.event.CurrentUpdateEvent;
import com.phidgets.event.CurrentUpdateListener;
import javax.swing.JTextField;
import javax.swing.JComboBox;

public class MCCurrentUpdateListener implements CurrentUpdateListener{

    private JComboBox motorCmb;
    private JTextField currentTxt;

    public MCCurrentUpdateListener(JTextField currentTxt, JComboBox motorCmb) {
        this.motorCmb = motorCmb;
        this.currentTxt = currentTxt;
    }

    public void currentUpdated(CurrentUpdateEvent currentUpdateEvent)
    {
        if(currentUpdateEvent.getIndex() == ((Integer)motorCmb.getSelectedItem()).intValue())
        {
            currentTxt.setText(Double.toString(currentUpdateEvent.getValue()));
        }
    }


}
